Imports System.Web.Services
Imports System.Data.SqlClient
Imports System.Web.Services.Protocols
Imports System.Xml.Serialization
Imports System.Xml

<WebService(Namespace := "http://tempuri.org/")> _
Public Class ReservationSessionID
    Inherits System.Web.Services.WebService

#Region " Web Services Designer Generated Code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Web Services Designer.
        InitializeComponent()

        'Add your own initialization code after the InitializeComponent() call

    End Sub

    'Required by the Web Services Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Web Services Designer
    'It can be modified using the Web Services Designer.  
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        components = New System.ComponentModel.Container()
    End Sub

    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        'CODEGEN: This procedure is required by the Web Services Designer
        'Do not modify it using the code editor.
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

#End Region


    <WebMethod()> Public Function Browse(ByVal SessionID As String) As DataSet
        If (ValidSession(SessionID) = True) Then
            Return BrowseHotels()
        Else
            Throw HotelReservationSOAPException("Invalid session id")
        End If
    End Function

    <WebMethod()> Public Function MakeReservation(ByVal SessionID As String, ByVal HotelID As Integer, ByVal CreditCardNumber As String) As Integer
        Dim intUserID As Integer

        If (ValidSession(SessionID) = True) Then
            intUserID = GetUserID(SessionID)
            Return ReserveRoom(intUserID, HotelID, CreditCardNumber)
        Else
            Throw HotelReservationSOAPException("Invalid session id")
        End If
    End Function

    '*****************************************************************************************
    ' NAME:         ValidSession
    ' DESCRIPTION:  Verifies that a row (session) exists in the DemoSessions table.  Returns 
    '               TRUE if SessionID exists in DemoSessions table and FALSE if it does not.
    '*****************************************************************************************
    Private Function ValidSession(ByVal SessionID As String) As Boolean
        Dim objConnection As SqlConnection = New SqlConnection(System.Configuration.ConfigurationSettings.AppSettings.Get("connectionString").ToString())
        Dim objSelectCommand As SqlCommand = New SqlCommand("SELECT * FROM DemoSessions WHERE SessionID = '" & SessionID & "'", objConnection)
        Dim bolReturnValue As Boolean

        objSelectCommand.Connection.Open()
        Dim objDataReader As SqlDataReader
        objDataReader = objSelectCommand.ExecuteReader()
        If (objDataReader.Read() = True) Then
            'Row exists, assume valid session
            bolReturnValue = True
        Else
            'Row does not exist, no valid session
            bolReturnValue = False
        End If
        objSelectCommand.Connection.Close()

        Return bolReturnValue
    End Function

    '*****************************************************************************************
    ' NAME:         BrowseHotels
    ' DESCRIPTION:  Returns a DataSet containing all of the hotels in the DemoHotels table.
    '*****************************************************************************************
    Private Function BrowseHotels() As DataSet
        Dim objConnection As SqlConnection = New SqlConnection(System.Configuration.ConfigurationSettings.AppSettings.Get("connectionString").ToString())
        Dim objSelectCommand As SqlCommand = New SqlCommand("SELECT * FROM DemoHotels", objConnection)
        Dim objDataAdapter As SqlDataAdapter = New SqlDataAdapter(objSelectCommand)

        Dim objReturnDataSet As DataSet = New DataSet()
        objDataAdapter.Fill(objReturnDataSet, "Hotels")

        Return objReturnDataSet
    End Function

    '*****************************************************************************************
    ' NAME:         GetUserID
    ' DESCRIPTION:  Returns the UserID associated with the SessionID passed into the method.
    '*****************************************************************************************
    Private Function GetUserID(ByVal SessionID As String) As Integer
        Dim objConnection As SqlConnection = New SqlConnection(System.Configuration.ConfigurationSettings.AppSettings.Get("connectionString").ToString())
        Dim objSelectCommand As SqlCommand = New SqlCommand("SELECT UserID FROM DemoSessions WHERE SessionID = '" & SessionID & "'", objConnection)
        Dim intUserID As Integer

        objSelectCommand.Connection.Open()
        intUserID = objSelectCommand.ExecuteScalar().ToString()
        objSelectCommand.Connection.Close()

        Return intUserID
    End Function


    '*****************************************************************************************
    ' NAME:         ReserveRoom
    ' DESCRIPTION:  Saves a row to the DemoReservations table and returns the ReservationID
    '               of the newly created row.  Raises an error if an error occurs
    '               during the processing of the reservation.
    '*****************************************************************************************
    Private Function ReserveRoom(ByVal UserID As Integer, ByVal HotelID As Integer, ByVal CreditCardNumber As String) As Integer
        Dim objConnection As SqlConnection = New SqlConnection(System.Configuration.ConfigurationSettings.AppSettings.Get("connectionString").ToString())
        objConnection.Open()

        Dim strSQL As String = "INSERT INTO DemoReservations (UserID, HotelID, CreditCardNumber) VALUES (" & UserID & "," & HotelID & ",'" & CreditCardNumber & "')"
        Dim objInsertCommand As SqlCommand = New SqlCommand(strSQL, objConnection)

        objInsertCommand.ExecuteNonQuery()

        Dim objSelectCommand As SqlCommand = New SqlCommand("SELECT @@IDENTITY FROM DemoReservations", objConnection)
        Dim intNewID As Integer
        intNewID = objSelectCommand.ExecuteScalar()

        objConnection.Close()

        Return intNewID
    End Function

    '*****************************************************************************************
    ' NAME:         HotelReservationSOAPException
    ' DESCRIPTION:  Returns a custom SOAP exception with the specified error message.
    '*****************************************************************************************
    Private Function HotelReservationSOAPException(ByVal Message As String) As SoapException
        'Raise SOAP exception, with description
        Dim doc As New System.Xml.XmlDocument()
        Dim node As System.Xml.XmlNode = doc.CreateNode(XmlNodeType.Element, _
            SoapException.DetailElementName.Name, SoapException.DetailElementName.Namespace)

        Dim details As System.Xml.XmlNode = doc.CreateNode(XmlNodeType.Element, _
            "HotelReservationFault", "http://tempuri.org/")

        details.InnerText = Message
        node.AppendChild(details)

        Return New SoapException("Fault occurred", SoapException.ClientFaultCode, Context.Request.Url.AbsoluteUri, node)
    End Function

End Class
